
#include "main.h"
#include "manager.h"
#include "mode.h"
#include "modeTitle.h"
#include "modeGame.h"
#include "camera.h"
#include "light.h"
#include "inputJoyStick.h"
#include "InputKeyboard.h"
#include "InputMouse.h"
#include "modelManager.h"
#include "texManager.h"
#include "renderer.h"
#include "debugStr.h"
#include "scene.h"
#include "effect3DPoly.h"
#include "Wwise.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// ÓIoϐ̐錾Ə
// -------- -------- -------- -------- -------- -------- -------- --------
CMode *CManager::m_mode = nullptr;
CRenderer *CManager::m_pRenderer = nullptr;
CInputKeyboard* CManager::m_pKeyboard = nullptr;
CInputJoyStick* CManager::m_pJoyStick = nullptr;
CInputMouse* CManager::m_pMouse = nullptr;
CModelManager *CManager::m_pModelManager = nullptr;		// f}l[W
CTexManager *CManager::m_pTexManager = nullptr;			// eNX`}l[W
CFontManager *CManager::m_pFontManager = nullptr;
CWwise *CManager::m_pWwise = nullptr;
CCamera *CManager::m_pCamera = nullptr;
CLight *CManager::m_pLight = nullptr;

// ======== ======== ======== ======== ======== ======== ======== ========
// 萔`
// -------- -------- -------- -------- -------- -------- -------- --------
static const int MAX_EFFECT = 512;		// GtFNg̍ő吔

// ------- 
HRESULT CManager::Init(HINSTANCE hInstance, HWND hWnd, bool bWindow)
{
	// _[̐
	m_pRenderer = new CRenderer;
	m_pRenderer->Init(hWnd, bWindow);

	// L[{[h
	m_pKeyboard = new CInputKeyboard();
	m_pKeyboard->Init(hInstance, hWnd);
	// WCXeBbN
	m_pJoyStick = new CInputJoyStick();
	m_pJoyStick->Init(hInstance, hWnd);
	// }EX
	m_pMouse = new CInputMouse();
	m_pMouse->Init(hInstance, hWnd);

	// wwise
	m_pWwise = new CWwise();
	m_pWwise->Init();

	// f}l[W̐
	m_pModelManager = new CModelManager;
	m_pModelManager->Init();

	// eNX`}l[W̐
	m_pTexManager = new CTexManager;
	m_pTexManager->Init();

	// tHg}l[W
//	m_pFontManager = new CFontManager;

	// J
	m_pCamera = new CCamera();
	m_pCamera->Init();

	// Cg
	m_pLight = new CLight();
	m_pLight->Init();

	// Rc|Sp[eBN
	CEffect3DPoly::Create(MAX_EFFECT, TEXNAME_EFFECT_WTOBLINE);

#ifdef _DEBUG
	// fobO\ptHg̐
	float fps = static_cast<float>(GetFPS());
	std::vector<float> vecFps;
	vecFps.push_back(fps);
	CDebugStr::Create(0, "FPS", vecFps);
#endif

	return S_OK;
}

// ------- I
void CManager::Uninit(void)
{

	// SceneS[X
	CScene::ReleaseAll();

	// GtFNgp3D|SS[X
	CEffect3DPoly::ReleaseAll();

	// fobO[X
#ifdef _DEBUG
	CDebugStr::ReleaseAll();
#endif

	// J̔j
	if (m_pCamera != nullptr)
	{
		m_pCamera->Uninit();
		delete m_pCamera;
		m_pCamera = nullptr;
	}

	// L[{[h̔j
	if (m_pKeyboard)
	{
		m_pKeyboard->Uninit();
		delete m_pKeyboard;
		m_pKeyboard = nullptr;
	}

	// WCXeBbN̔j
	if (m_pJoyStick)
	{
		m_pJoyStick->Uninit();
		delete m_pJoyStick;
		m_pJoyStick = nullptr;
	}

	// }EX̔j
	if (m_pMouse)
	{
		m_pMouse->Uninit();
		delete m_pMouse;
		m_pMouse = nullptr;
	}

	// wwise
	m_pWwise->Uninit();

	// f}l[W̔j
	if (m_pModelManager != nullptr)
	{
		m_pModelManager->Uninit();
		delete m_pModelManager;
		m_pModelManager = nullptr;
	}

	// eNX`}l[W̔j
	if (m_pTexManager != nullptr)
	{
		m_pTexManager->Uninit();
		delete m_pTexManager;
		m_pTexManager = nullptr;
	}

//	if (m_pFontManager != nullptr)
//	{
//		m_pFontManager->Uninit();
//		delete m_pFontManager;
//		m_pFontManager = nullptr;
//	}

	// _[̔j
	if (m_pRenderer != nullptr)
	{
		m_pRenderer->Uninit();
		delete m_pRenderer;
		m_pRenderer = nullptr;
	}
}

// ------- XV
void CManager::Update(HWND hWnd)
{
	// L[{[h
	if (m_pKeyboard)m_pKeyboard->Update();
	// WCXeBbN
	if (m_pJoyStick)m_pJoyStick->Update();
	// }EX
	if (m_pMouse)m_pMouse->Update(hWnd);

	// fobOSXV
#ifdef _DEBUG
	CDebugStr::UpdateAll();
#endif

	// e[h̍XV
	m_mode->Update();

	// sceneSXV
	CScene::UpdateAll(0);
	CScene::UpdateAll(1);
	CEffect3DPoly::UpdateAll();
	CScene::UpdateAll(2);
	CScene::UpdateAll(3);
	CScene::UpdateAll(4);
	CScene::UpdateAll(5);
	CScene::UpdateAll(6);
	CScene::UpdateAll(7);

	// J̍XV
	if (m_pCamera != nullptr)m_pCamera->Update();

	// wwise
	m_pWwise->Update();

#ifdef _DEBUG
	// fobO\ptHg̍XV
	float fps = static_cast<float>(GetFPS());
	std::vector<float> vecFps;
	vecFps.push_back(fps);
	CDebugStr::Set("FPS", vecFps);
#endif
}

// ------- `
void CManager::Draw(void)
{

	// `̊Jn
	if (m_pRenderer->DrawBigin() == false)return;

	// J̃}gNX̐ݒ
	m_pCamera->Set();

	// e[h̕`
	m_mode->Draw();

	// sceneS`
	CScene::DrawAll(0);
	CScene::DrawAll(1);
	CEffect3DPoly::DrawAll();
	CScene::DrawAll(2);
	CScene::DrawAll(3);
	CScene::DrawAll(4);
	CScene::DrawAll(5);
	CScene::DrawAll(6);
	CScene::DrawAll(7);

	// fobOS`
#ifdef _DEBUG
	CDebugStr::DrawAll();
#endif

	m_pCamera->Draw();

	// `̏I
	m_pRenderer->DrawEnd();

}

// -------- [hύX
void CManager::SetMode(CMode *mode)
{
	if (m_mode != nullptr)
	{
		m_mode->Uninit();
		delete m_mode;
	}
	m_mode = mode;
	if (m_mode != nullptr)
	{
		m_mode->Init();
	}
}